//service worker version (keep synced with app version)
const version = '0.1.0';

//current cache name
const currentCache = 'kcad-ar-framework-' + version;

//handles precache
self.addEventListener('install', event => {
  event.waitUntil(
    caches.open(currentCache).then(cache => {
      return cache.addAll([
        'index.html',
        'index.js',
        'manifest.json',
        'images/apple-touch-icon.png',
        'images/index_atlas_NP_1.jpg',
        'images/index_atlas_P_1.png',
        'libraries/createjs-1.3.4.js',
        'libraries/platform-1.3.6.min.js',
        'libraries/zim-00.min.js',
        'modules/app.js',
        'modules/resize.js'
      ]);
    })
  );
});

//removes old caches
self.addEventListener('activate', event => {
  event.waitUntil(
    caches.keys().then(cacheNames => {
      return Promise.all(
        cacheNames
          .filter(cacheName => {
            return cacheName === currentCache ? false : true;
          })
          .map(cacheName => {
            return caches.delete(cacheName);
          }),
      );
    }),
  );
});

//handles cache
self.addEventListener('fetch', event => {
  if (event.request.method === 'POST' || event.request.url.startsWith('chrome-extension://')) {
    //ignores post and chrome extension requests
    return;
  } else if (event.request.url.includes('/examples/')) {
    //ignores example file requests
    return;
  } else {
     //handles all other requests with cache-then-network
    event.respondWith(
      caches.open(currentCache).then(cache => {
        return cache.match(event.request).then(response => {
          return response || fetch(event.request).then(response => {
            cache.put(event.request, response.clone());
            return response;
          });
        });
      })
    );
  }
});

//receives messages from app
self.addEventListener('message', (event) => {
  if (event.data.action === 'skipWaiting') {
    //skips waiting to allow install on update
    self.skipWaiting();
  }
});