import { app } from './app.js';

//delays resize on mobile after intial display to account for orientation change
const onResize = (firstResize) => {
    let resizeDelay = firstResize != true && (app.os.includes('Android') || app.os.includes('iOS')) ? 750 : 0;
    setTimeout(resize, resizeDelay);
}

//resizes interface to match screen size
const resize = () => {
    //sets device orientation
    app.orientation = document.documentElement.clientWidth > document.documentElement.clientHeight ? 'landscape' : 'portrait';

    //sets scale in relation to original size
    app.scaleX = document.documentElement.clientWidth / app.lib.properties.width;
    app.scaleY = document.documentElement.clientHeight / app.lib.properties.height;

    //determines scale to keep interface on screen
    app.scaleRatio = (app.scaleX < app.scaleY) ? app.scaleX : app.scaleY;

    //limits to not scale larger than original size
    app.scaleRatio = app.scaleRatio < 1 ? app.scaleRatio : 1;

    //scales stage and html elements
    app.stage.scaleX = app.stage.scaleY = window.devicePixelRatio;
    app.canvas.width = document.documentElement.clientWidth * window.devicePixelRatio;
    app.canvas.height = document.documentElement.clientHeight * window.devicePixelRatio;
    app.canvas.style.width = app.dom_overlay_container.style.width = app.anim_container.style.width = document.documentElement.clientWidth + 'px';
    app.canvas.style.height = app.dom_overlay_container.style.height = app.anim_container.style.height = document.documentElement.clientHeight + 'px';

    //scales and positions interface elements
    app.root.sca(app.scaleRatio);
    app.root.x = document.documentElement.clientWidth / 2;
    app.root.y = document.documentElement.clientHeight / 2;
}

export { onResize };
