import { onResize } from './resize.js';

//global variables
const app = {
    version: '0.1.0', //keep synced with serviceworker version
    browser: '',
    os: '',
    device: '',
    orientation: '',
    scaleX: 0,
    scaleY: 0,
    scaleRatio: 0,
    canvas: {},
    lib: {},
    stage: {},
    anim_container: {},
    dom_overlay_container: {},
    root: {}
};

//initializes application
const appInit = (canvas, lib, stage, anim_container, dom_overlay_container) => {
    //assigns objects passed in from index.html
    app.canvas = canvas;
    app.lib = lib;
    app.stage = stage;
    app.anim_container = anim_container;
    app.dom_overlay_container = dom_overlay_container;

    //device detection (uses platform js library)
    app.browser = platform.name;
    app.os = platform.os.family;
    app.device = platform.product;

    //adjusts webfont position
    let webfontOffset = 0;
    if ((app.browser.includes('Chrome') && !app.os.includes('iOS')) || app.browser.includes('Firefox') || app.browser.includes('Edge')) {
        webfontOffset = .2;
    }

    createjs.Text.prototype._drawTextLine = function (ctx, text, y) {
        if (this.textBaseline == 'top') {
            let lineHeight = this.lineHeight || this.getMeasuredLineHeight();
            y += lineHeight * webfontOffset;
        }
        if (this.outline) {
            ctx.strokeText(text, 0, y, this.maxWidth || 0xFFFF);
        } else {
            ctx.fillText(text, 0, y, this.maxWidth || 0xFFFF);
        }
    };

    //creates root object from library
    app.root = new app.lib.root();

    //adds zim.js properties
    zimify(app.root);

    //adds to stage
    app.stage.addChild(app.root);

    //handles screen size
    window.addEventListener('resize', onResize);
    onResize(true);

    //sets up ar launch buttons
    app.root.button1.on('click', () => {
        openLink('examples/ar-marker-video');
    });

    app.root.button2.on('click', () => {
        openLink('examples/ar-marker-3d');
    });

    app.root.button3.on('click', () => {
        openLink('examples/ar-marker-video-360');
    });

    app.root.button4.on('click', () => {
        openLink('examples/ar-geolocation-3d');
    });

    app.root.button5.on('click', () => {
        openLink('examples/ar-image-video');
    });

    app.root.button6.on('click', () => {
        openLink('examples/ar-image-3d');
    });

    app.root.button7.on('click', () => {
        openLink('examples/ar-face-3d-props');
    });

    app.root.button8.on('click', () => {
        openLink('examples/ar-face-3d-mask');
    });
};

//opens the link when online, or alerts the user when offline
const openLink = (link) => {
    if (navigator.onLine) {
        location.href = link;
    } else {
        alert('The application is offline, please establish a network connection to continue.');
    }
};

export { app, appInit };